﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ArrayTypes
{
    class Program
    {
        static void Main(string[] args)
        {
            CalendarEvent[] events = SeparateEvents();
            // Ponieważ wszystkie zdarzenia są niezależne, zatem modyfikacja
            // tytułu pierwszego z nich, zmieni tylko tytuł.
            ModifyFirst(events);

            Console.WriteLine();


            events = AllTheSameEvent();
            // Ponieważ wszystkie elementy tablicy odwołują się do tego samego obiektu,
            // zatem zmodyfikowany tytuł pierwszego elementu tablicy
            // będzie widoczny także jako tytuł drugiego elementu.
            ModifyFirst(events);

            Console.WriteLine();


            // Listing 7-12. Tablica liczb całkowitych.
            int[] numbers = { 2, 3, 5, 7, 11 };

            int thirdElementInArray = numbers[2];
            thirdElementInArray += 1;
            Console.WriteLine("Zmienna: " + thirdElementInArray);
            Console.WriteLine("Element tablicy: " + numbers[2]);
        }

        private static void ModifyFirst(CalendarEvent[] events)
        {
            Console.WriteLine(events[0].Title);
            Console.WriteLine(events[1].Title);

            events[0].Title = "Zmieniono";

            Console.WriteLine(events[0].Title);
            Console.WriteLine(events[1].Title);
        }

        private static CalendarEvent[] SeparateEvents()
        {
            // Listing 7-10. Tworzenie tablicy zawierającej obiekty naszej klasy.
            CalendarEvent[] events =
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                },
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };

            CalendarEvent thirdElementInArray = events[2];
            thirdElementInArray.Title = "Zmodyfikowana nazwa";
            Console.WriteLine("Zmienna: " + thirdElementInArray.Title);
            Console.WriteLine("Element tablicy: " + events[2].Title);

            return events;
        }
        private static CalendarEvent[] AllTheSameEvent()
        {
            // Listing 7-11. Wiele elementów tablicy odwołujących się do tego samego obiektu.
            CalendarEvent theOnlyEvent = new CalendarEvent
            {
                Title = "Swingowa potańcówka na nabrzeżu",
                StartTime = new DateTimeOffset(2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                Duration = TimeSpan.FromHours(4)
            };
            CalendarEvent[] events =
            {
                theOnlyEvent,
                theOnlyEvent,
                theOnlyEvent,
                theOnlyEvent,
                theOnlyEvent
            };

            return events;
        }
    }
}
